package com.roid.bettingtips

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.TextUtils
import android.text.method.LinkMovementMethod
import android.util.Log
import android.widget.*
import com.google.android.gms.tasks.OnCompleteListener
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.auth.ktx.auth
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.ktx.database
import com.google.firebase.ktx.Firebase
import com.tapadoo.alerter.Alerter
import com.roid.bettingtips.data.UserData
import okhttp3.*
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException

class EmailSignActivity : AppCompatActivity() {

    private val client = OkHttpClient()
    private var serverUrl: String = "https://api.roidbetting.online/getId"
    private lateinit var auth: FirebaseAuth
    private var loadingDialog: LoadingDialog = LoadingDialog()
    private lateinit var database: DatabaseReference
    private lateinit var emailInp: EditText
    private lateinit var passInp: EditText
    private lateinit var passReInp: EditText
    private lateinit var nameInp: EditText
    private lateinit var regBtn: Button

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_email_sign)

        database = Firebase.database.reference
        auth = Firebase.auth

        regBtn = findViewById(R.id.signupBtn)
        emailInp = findViewById(R.id.email)
        passInp = findViewById(R.id.password)
        passReInp = findViewById(R.id.rePassword)
        nameInp = findViewById(R.id.namesur)

        regBtn.setOnClickListener {
            val email = emailInp.text.toString()
            val password = passInp.text.toString()
            val rePassword = passReInp.text.toString()
            val name = nameInp.text.toString()

            if(email.isEmailValid()){
                if(name != "" && password != ""){
                    if(password == rePassword){
                        showProgressBar()
                        auth.createUserWithEmailAndPassword(email, password).addOnCompleteListener(this, OnCompleteListener{ task ->
                            if (task.isSuccessful) {
                                val user = auth.currentUser

                                if(user != null){
                                    newUserSave(user.uid, name, email)
                                }
                            } else {
                                hideProgressBar()
                                errorAlert(getString(R.string.emailDuplicateError))
                                passInp.text.clear()
                                passReInp.text.clear()
                            }
                        })
                    }else{
                        passInp.text.clear()
                        passReInp.text.clear()
                        showInfoMsg(getString(R.string.passwordError))
                    }
                }else{
                    showInfoMsg(getString(R.string.emptyError))
                }
            }else{
                showInfoMsg(getString(R.string.emailError))
            }
        }

        val regTextBtm = findViewById<TextView>(R.id.regTextBottom)
        regTextBtm.movementMethod = LinkMovementMethod.getInstance()
    }

    private fun newUserSave(userId: String, displayName: String, email: String?) {
        val url = serverUrl

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                runOnUiThread {
                    showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                runOnUiThread {
                    try {
                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        if (json.has("id")) {
                            val id = json.getInt("id")
                            val name = displayName.split(" ").toTypedArray()
                            var firstName = ""
                            var lastName = ""

                            if(name.getOrNull(0) != null){firstName = name[0]}
                            if(name.getOrNull(1) != null){lastName = name[1]}

                            val prize = if(json.has("register_prize")){
                                json.getInt("register_prize")
                            }else{
                                0
                            }

                            val user = UserData(id, firstName, lastName, email, prize,0,0,0,0,"0","0","0","0", "0")

                            database.child("users").child(userId).setValue(user)
                                .addOnSuccessListener {
                                    hideProgressBar()
                                    val intent = Intent(baseContext, MainActivity::class.java)
                                    startActivity(intent)
                                    finish()
                                }
                                .addOnFailureListener {
                                    showErrorMsg()
                                }
                        }else{
                            showErrorMsg()
                        }
                    } catch (jpe: JSONException) {
                        showErrorMsg()
                        Log.d(TAG, jpe.toString())
                    } catch (ioe: IOException) {
                        showErrorMsg()
                        Log.d(TAG, ioe.toString())
                    }
                }
            }
        })
    }

    private fun showErrorMsg(){
        Alerter.create(this)
            .setTitle(getString(R.string.error))
            .setText(getString(R.string.loginFail))
            .setIcon(R.drawable.ic_error)
            .setBackgroundColorRes(R.color.error_color)
            .show()
    }

    private fun showInfoMsg(infoMsg: String){
        Alerter.create(this)
            .setTitle(getString(R.string.info))
            .setText(infoMsg)
            .setIcon(R.drawable.ic_error)
            .setBackgroundColorRes(R.color.info_color)
            .show()
    }

    private fun errorAlert(errMsg: String){
        Alerter.create(this)
            .setTitle(getString(R.string.error))
            .setText(errMsg)
            .setIcon(R.drawable.ic_error)
            .setBackgroundColorRes(R.color.error_color)
            .show()
    }

    private fun showProgressBar(){
        if(!loadingDialog.isVisible){
            loadingDialog.show(supportFragmentManager, "loadingDialog")
        }
    }

    private fun hideProgressBar(){
        if(loadingDialog.isVisible){
            loadingDialog.dismiss()
        }
    }

    private fun String.isEmailValid(): Boolean {
        return !TextUtils.isEmpty(this) && android.util.Patterns.EMAIL_ADDRESS.matcher(this).matches()
    }

    companion object {
        private const val TAG = "GoogleActivity"
    }
}