package com.roid.bettingtips

import android.content.Intent
import android.net.Uri
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import androidx.drawerlayout.widget.DrawerLayout
import androidx.navigation.findNavController
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.navigateUp
import androidx.navigation.ui.setupActionBarWithNavController
import androidx.navigation.ui.setupWithNavController
import com.google.android.material.navigation.NavigationView
import com.roid.bettingtips.databinding.ActivityMainBinding
import android.widget.RelativeLayout
import android.widget.TextView
import android.widget.Toast
import com.android.billingclient.api.*
import com.google.android.gms.ads.AdRequest
import com.google.android.gms.ads.LoadAdError
import com.google.android.gms.ads.MobileAds
import com.google.android.gms.ads.rewarded.RewardedAd
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions
import com.google.firebase.auth.FirebaseAuth
import com.google.firebase.auth.ktx.auth
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.ValueEventListener
import com.google.firebase.database.ktx.database
import com.google.firebase.ktx.Firebase
import com.onesignal.OneSignal
import com.tapadoo.alerter.Alerter
import okhttp3.*
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.util.*
import kotlin.concurrent.schedule


class MainActivity : AppCompatActivity(), PurchasesUpdatedListener, AcknowledgePurchaseResponseListener {
    private val serverUrl: String = "https://api.roidbetting.online"
    private val client = OkHttpClient()
    private lateinit var appBarConfiguration: AppBarConfiguration
    private lateinit var binding: ActivityMainBinding
    private lateinit var database: DatabaseReference
    private lateinit var billingClient: BillingClient
    private var isBillingConnected = false
    private var loadingDialog: LoadingDialog = LoadingDialog()
    private var utoken: String = "null"
    private var ovun: Long = 0
    private var htft: Long = 0
    private var odds: Long = 0
    private var plat: Long = 0
    private var ovunSku: String = "0"
    private var htftSku: String = "0"
    private var oddsSku: String = "0"
    private var platSku: String = "0"
    private var isLoading = false
    private var mRewardedAd: RewardedAd? = null
	private lateinit var userName: TextView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        database = Firebase.database.reference
		val share = findViewById<RelativeLayout>(R.id.shareBtn)
        val userna = findViewById<RelativeLayout>(R.id.userNa)
        val userName = findViewById<TextView>(R.id.userName)
        val userSurname = findViewById<TextView>(R.id.userSurname)
        val logoutBtn = findViewById<TextView>(R.id.logoutBtn)
        val privacyBtn = findViewById<RelativeLayout>(R.id.privacyBtn)
        val earnBtn = findViewById<RelativeLayout>(R.id.earnBtn)
        val wpBtn = findViewById<RelativeLayout>(R.id.wpBtn)
        val fbBtn = findViewById<RelativeLayout>(R.id.fbBtn)
        val instaBtn = findViewById<RelativeLayout>(R.id.instaBtn)
        val mailBtn = findViewById<RelativeLayout>(R.id.mailBtn)

        MobileAds.initialize(this) {}
        setupOnesignal()
        validateSubs()

        setSupportActionBar(binding.appBarMain.toolbar)
        supportActionBar!!.setDisplayShowTitleEnabled(false)

        val drawerLayout: DrawerLayout = binding.drawerLayout
        val navView: NavigationView = binding.navView
        val navController = findNavController(R.id.nav_host_fragment_content_main)

        appBarConfiguration = AppBarConfiguration(
            setOf(
                R.id.nav_home
            ), drawerLayout
        )
        setupActionBarWithNavController(navController, appBarConfiguration)
        navView.setupWithNavController(navController)

        if(!loadingDialog.isAdded && !isLoading){
            loadingDialog.show(supportFragmentManager, "loadingDialog")
            isLoading = true
        }

        FirebaseAuth.getInstance().currentUser?.getIdToken(true)?.addOnSuccessListener {
            it.token?.let { it1 -> utoken = it1 }
        }

        billingClient =  BillingClient.newBuilder(this).enablePendingPurchases().setListener(this).build()

        privacyBtn.setOnClickListener(){
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/privacy.php")
            startActivity(intent)
        }
		        share.setOnClickListener(){

            val shareIntent = Intent()
            shareIntent.action = Intent.ACTION_SEND
            shareIntent.type="text/plain"
            shareIntent.putExtra(Intent.EXTRA_TEXT, "https://play.google.com/store/apps/details?id=com.firetips.bettingtips/");
            startActivity(Intent.createChooser(shareIntent,getString(R.string.share)))


        }
		        FirebaseAuth.getInstance().currentUser?.getIdToken(true)?.addOnSuccessListener {
            val user = Firebase.auth.currentUser
            if (user != null) {
                //loadAd(user.uid)
                val ordersRef = database.child("users").child(user.uid)
                val valueEventListener = object : ValueEventListener {
                    override fun onDataChange(dataSnapshot: DataSnapshot) {
                        userName.text = dataSnapshot.child("name").value.toString()
                        userSurname.text = dataSnapshot.child("surname").value.toString()
                    }

                    override fun onCancelled(databaseError: DatabaseError) {
                        Log.d("Data", databaseError.message)
                    }
                }
                ordersRef.addValueEventListener(valueEventListener)
            }
			     }

        earnBtn.setOnClickListener(){
            watchAdAlert()
        }

        wpBtn.setOnClickListener(){
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/redirect.php?to=wp")
            startActivity(intent)
        }

        fbBtn.setOnClickListener(){
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/redirect.php?to=fb")
            startActivity(intent)
        }

        instaBtn.setOnClickListener(){
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/redirect.php?to=insta")
            startActivity(intent)
        }

        mailBtn.setOnClickListener(){
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/redirect.php?to=mail")
            startActivity(intent)
        }

        logoutBtn.setOnClickListener(){
            logoutAlert()
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        menuInflater.inflate(R.menu.main, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        val id: Int = item.itemId
        if (id == R.id.globeBtn) {
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://roidbetting.online/")
            startActivity(intent)
            return true
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onSupportNavigateUp(): Boolean {
        val navController = findNavController(R.id.nav_host_fragment_content_main)
        return navController.navigateUp(appBarConfiguration) || super.onSupportNavigateUp()
    }

    private fun validateSubs(){
        val user = Firebase.auth.currentUser
        if (user != null) {
            loadAd(user.uid)
            val ordersRef = database.child("users").child(user.uid)
            val valueEventListener = object : ValueEventListener {
                override fun onDataChange(dataSnapshot: DataSnapshot) {
                    ovun =  dataSnapshot.child("ovun").value.toString().toLong()
                    htft = dataSnapshot.child("htft").value.toString().toLong()
                    odds = dataSnapshot.child("twoh").value.toString().toLong()
                    plat = dataSnapshot.child("plat").value.toString().toLong()
                    ovunSku =  dataSnapshot.child("ovun_sku").value.toString()
                    htftSku = dataSnapshot.child("htft_sku").value.toString()
                    oddsSku = dataSnapshot.child("twoh_sku").value.toString()
                    platSku = dataSnapshot.child("plat_sku").value.toString()

                    if(loadingDialog.isVisible){
                        loadingDialog.dismiss()
                        isLoading = false
                    }

                    Timer().schedule(2000){
                        if(loadingDialog.isVisible){
                            loadingDialog.dismiss()
                        }
                    }

                    if(!isBillingConnected){
                        startBillingCon()
                    }
                }

                override fun onCancelled(databaseError: DatabaseError) {
                    Log.d("Data", databaseError.message)
                }
            }
            ordersRef.addValueEventListener(valueEventListener)
        } else {
            val intent = Intent(this, SplashActivity::class.java)
            startActivity(intent)
            this.finish()
        }
    }

    private fun startBillingCon(){
        billingClient.startConnection(object : BillingClientStateListener {
            override fun onBillingSetupFinished(billingResult: BillingResult) {

                if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) {
                    acknowledgeSubs()
                    if(Calendar.getInstance() > getDate(ovun) && ovunSku != "0"){
                        validateSub(ovunSku)
                    }
                    if(Calendar.getInstance() > getDate(htft) && htftSku != "0"){
                        validateSub(htftSku)
                    }
                    if(Calendar.getInstance() > getDate(odds) && oddsSku != "0"){
                        validateSub(oddsSku)
                    }
                    if(Calendar.getInstance() > getDate(plat) && platSku != "0"){
                        validateSub(platSku)
                    }
                }
            }

            override fun onBillingServiceDisconnected() {
                startBillingCon()
            }
        })
    }

    fun purchase(id: String) {
        Log.d("testRun", id)
        if (billingClient.isReady) {
            when(id){
                "dia100" -> initiateWandPurchase(id)
                "dia500" -> initiateWandPurchase(id)
                "dia1000" -> initiateWandPurchase(id)
                "dia5000" -> initiateWandPurchase(id)
                "dia10000" -> initiateWandPurchase(id)
                else -> initiatePurchase(id)
            }
        } else {
            billingClient = BillingClient.newBuilder(this).enablePendingPurchases().setListener(this).build()
            billingClient.startConnection(object : BillingClientStateListener {
                override fun onBillingSetupFinished(billingResult: BillingResult) {
                    if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) {
                        when(id){
                            "dia100" -> initiateWandPurchase(id)
                            "dia500" -> initiateWandPurchase(id)
                            "dia1000" -> initiateWandPurchase(id)
                            "dia5000" -> initiateWandPurchase(id)
                            "dia10000" -> initiateWandPurchase(id)
                            else -> initiatePurchase(id)
                        }

                    } else {
                        Toast.makeText(this@MainActivity, "Hata oluştu", Toast.LENGTH_SHORT).show()
                    }
                }

                override fun onBillingServiceDisconnected() {}
            })
        }
    }

    private fun initiatePurchase(id: String) {
        val skuList = listOf(id)
        val params = SkuDetailsParams.newBuilder()
        params.setSkusList(skuList).setType(BillingClient.SkuType.SUBS)
        billingClient.querySkuDetailsAsync(params.build()) { billingResult, skuDetailsList ->
            if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) {
                if (skuDetailsList != null) {
                    if (skuDetailsList.isNotEmpty()) {
                        val flowParams = BillingFlowParams.newBuilder()
                            .setSkuDetails(skuDetailsList[0])
                            .build()
                        billingClient.launchBillingFlow(this, flowParams)
                    } else {
                        //try to add item/product id "purchase" inside managed product in google play console
                        Toast.makeText(this@MainActivity, getString(R.string.itemNotFound), Toast.LENGTH_SHORT).show()
                    }
                }else{
                    Toast.makeText(this@MainActivity, getString(R.string.itemNotFound), Toast.LENGTH_SHORT).show()
                }
            } else {
                Toast.makeText(this@MainActivity, getString(R.string.error), Toast.LENGTH_SHORT).show()
            }
        }
    }

    private fun initiateWandPurchase(id: String) {
        val skuList = listOf(id)
        val params = SkuDetailsParams.newBuilder()
        params.setSkusList(skuList).setType(BillingClient.SkuType.INAPP)
        billingClient.querySkuDetailsAsync(params.build()) { billingResult, skuDetailsList ->
            if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) {
                if (skuDetailsList != null) {
                    if (skuDetailsList.isNotEmpty()) {
                        val flowParams = BillingFlowParams.newBuilder()
                            .setSkuDetails(skuDetailsList[0])
                            .build()
                        billingClient.launchBillingFlow(this, flowParams)
                    } else {
                        //try to add item/product id "purchase" inside managed product in google play console
                        Toast.makeText(this@MainActivity, getString(R.string.itemNotFound), Toast.LENGTH_SHORT).show()
                    }
                }else{
                    Toast.makeText(this@MainActivity, getString(R.string.itemNotFound), Toast.LENGTH_SHORT).show()
                }
            } else {
                Toast.makeText(this@MainActivity, getString(R.string.error), Toast.LENGTH_SHORT).show()
            }
        }
    }

    override fun onPurchasesUpdated(billingResult: BillingResult, purchases: List<Purchase>?) {
        if (billingResult.responseCode == BillingClient.BillingResponseCode.OK && purchases != null) {
            for (purchase in purchases) {
                val sku = purchase.skus.toString()
                val token = purchase.purchaseToken

                when(sku){
                    "dia100" -> {
                        verifyWandPurchase(sku, token)
                        val consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.purchaseToken).build()
                        billingClient.consumeAsync(consumeParams) { billingResult, _ -> if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) { } }
                    }
                    "dia500" -> {
                        verifyWandPurchase(sku, token)
                        val consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.purchaseToken).build()
                        billingClient.consumeAsync(consumeParams) { billingResult, _ -> if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) { } }
                    }
                    "dia1000" -> {
                        verifyWandPurchase(sku, token)
                        val consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.purchaseToken).build()
                        billingClient.consumeAsync(consumeParams) { billingResult, _ -> if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) { } }
                    }
                    "dia5000" -> {
                        verifyWandPurchase(sku, token)
                        val consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.purchaseToken).build()
                        billingClient.consumeAsync(consumeParams) { billingResult, _ -> if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) { } }
                    }
                    "dia10000" -> {
                        verifyWandPurchase(sku, token)
                        val consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.purchaseToken).build()
                        billingClient.consumeAsync(consumeParams) { billingResult, _ -> if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) { } }
                    }
                    else -> verifyPurchase(sku, token)
                }

            }
        } else if (billingResult.responseCode == BillingClient.BillingResponseCode.ITEM_ALREADY_OWNED && purchases != null) {
            for (purchase in purchases) {
                if (!purchase.isAcknowledged) {
                    val acknowledgePurchaseParams = AcknowledgePurchaseParams.newBuilder()
                        .setPurchaseToken(purchase.purchaseToken)
                        .build()
                    billingClient.acknowledgePurchase(acknowledgePurchaseParams, this)
                }
            }

        } else if (billingResult.responseCode == BillingClient.BillingResponseCode.USER_CANCELED) {
            // Handle an error caused by a user cancelling the purchase flow.
        } else {
            Toast.makeText(this@MainActivity, getString(R.string.error), Toast.LENGTH_SHORT).show()
        }
    }


    private fun verifyPurchase(sku: String, token: String){
        if(!loadingDialog.isAdded && !isLoading){
            loadingDialog.show(supportFragmentManager, "loadingDialog")
            isLoading = true
        }

        val url = "$serverUrl/verify_sub/$token/$utoken/$sku"
        Log.d("testRun", url)

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                runOnUiThread() {
                    hideLoading()
                    showErrorMsg(1)
                }
            }

            override fun onResponse(call: Call, response: Response) {
                runOnUiThread() {
                    try {
                        val strResponse = response.body()!!.string()
                        val json: JSONObject = JSONObject(strResponse)
                        hideLoading()
                        if (json.has("status")) {
                            when (json.getString("status")) {
                                "error" -> showErrorMsg(2)
                                "ok" -> showSuccessMsg(1)
                                "set_to_zero" -> showInfoMsg(1)
                                "renew_ok" -> showSuccessMsg(2)
                                else -> showErrorMsg(2)
                            }
                        } else {
                            showErrorMsg(3)
                        }
                    } catch (jpe: JSONException) {
                        hideLoading()
                        showErrorMsg(1)
                    } catch (ioe: IOException) {
                        hideLoading()
                        showErrorMsg(1)
                    }
                }
            }
        })
    }

    private fun verifyWandPurchase(sku: String, token: String){
        if(!loadingDialog.isAdded && !isLoading){
            loadingDialog.show(supportFragmentManager, "loadingDialog")
            isLoading = true
        }

        val url = "$serverUrl/verify_purchase/$token/$utoken/$sku"
        Log.d("testRun", url)

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                runOnUiThread() {
                    hideLoading()
                    showErrorMsg(3)
                }
            }

            override fun onResponse(call: Call, response: Response) {
                runOnUiThread() {
                    try {
                        val strResponse = response.body()!!.string()
                        val json: JSONObject = JSONObject(strResponse)
                        hideLoading()
                        if (json.has("status")) {
                            when (json.getString("status")) {
                                "error" -> showErrorMsg(3)
                                "ok" -> showSuccessMsg(3)
                                else -> showErrorMsg(3)
                            }
                        } else {
                            showErrorMsg(3)
                        }
                    } catch (jpe: JSONException) {
                        hideLoading()
                        showErrorMsg(3)
                    } catch (ioe: IOException) {
                        hideLoading()
                        showErrorMsg(3)
                    }
                }
            }
        })
    }

    private fun validateSub(subSku: String){
        billingClient.queryPurchaseHistoryAsync(BillingClient.SkuType.SUBS) { billingResult, purchasesList ->
            if (billingResult.responseCode == BillingClient.BillingResponseCode.OK && purchasesList != null) {
                for (purchase in purchasesList) {
                    if(subSku.equals(purchase.skus)){
                        verifyPurchase(purchase.skus.toString(), purchase.purchaseToken)
                    }
                }
            }
        }
    }

    private fun acknowledgeSubs(){
        billingClient.queryPurchaseHistoryAsync(BillingClient.SkuType.SUBS) { billingResult, purchasesList ->
            if (billingResult.responseCode == BillingClient.BillingResponseCode.OK && purchasesList != null) {
                for (purchase in purchasesList) {
                    val acknowledgePurchaseParams = AcknowledgePurchaseParams.newBuilder()
                        .setPurchaseToken(purchase.purchaseToken)
                        .build()
                    billingClient.acknowledgePurchase(acknowledgePurchaseParams, this)
                }
            }
        }
    }

    private fun logoutAlert(){
        val builder = androidx.appcompat.app.AlertDialog.Builder(this)
        builder.setTitle(getString(R.string.logout))
        builder.setMessage(getString(R.string.sureToLogout))
            .setCancelable(true)
            .setPositiveButton(getString(R.string.logout)) { dialog, id ->
                Firebase.auth.signOut()
                val intent = Intent(this, SignActivity::class.java)
                startActivity(intent)
                this.finish()
            }
            .setNegativeButton(getString(R.string.cancel)) { dialog, id ->
                dialog.dismiss()
            }
        val alert = builder.create()
        alert.show()
    }

    private fun showErrorMsg(id: Int){
        val msg = when(id){
            1 -> getString(R.string.errorConnection)
            2 -> getString(R.string.errorSubVerify)
            3 -> getString(R.string.unkownError)
            else -> getString(R.string.unkownError)
        }

        Alerter.create(this)
            .setTitle(getString(R.string.error))
            .setText(msg)
            .setIcon(R.drawable.ic_error)
            .setBackgroundColorRes(R.color.error_color)
            .show()
    }

    private fun showSuccessMsg(id: Int){
        val msg = when(id){
            1 -> getString(R.string.subscribed)
            2 -> getString(R.string.renewSub)
            3 -> getString(R.string.wandPurchased)
            else -> getString(R.string.subscribed)
        }

        Alerter.create(this)
            .setTitle(getString(R.string.jobSuccessful))
            .setText(msg)
            .setIcon(R.drawable.ic_baseline_check_circle_outline)
            .setBackgroundColorRes(R.color.success_color)
            .show()
    }

    private fun showInfoMsg(id: Int){
        val msg = when(id){
            1 -> getString(R.string.subEnded)
            else -> getString(R.string.subEnded)
        }

        Alerter.create(this)
            .setTitle(getString(R.string.info))
            .setText(msg)
            .setIcon(R.drawable.ic_error)
            .setBackgroundColorRes(R.color.info_color)
            .show()
    }

    private fun hideLoading(){
        if(loadingDialog.isVisible){
            loadingDialog.dismiss()
            isLoading = false
        }
    }

    private fun watchAdAlert(){
        val builder = androidx.appcompat.app.AlertDialog.Builder(this)
        builder.setTitle(getString(R.string.watchAd))
        builder.setMessage(getString(R.string.watchAdDes))
            .setCancelable(true)
            .setPositiveButton(getString(R.string.ok)) { dialog, id ->
                showAd()
            }
            .setNegativeButton(getString(R.string.cancel)) { dialog, id ->
                dialog.dismiss()
            }
        val alert = builder.create()
        alert.show()
    }

    private fun loadAd(uid: String){
        val adRequest = AdRequest.Builder().build()
        RewardedAd.load(this, "ca-app-pub-7322823647168577/3404429633", adRequest, object : RewardedAdLoadCallback() {
            override fun onAdFailedToLoad(adError: LoadAdError) {
                mRewardedAd = null
            }

            override fun onAdLoaded(rewardedAd: RewardedAd) {
                mRewardedAd = rewardedAd
                val options = ServerSideVerificationOptions.Builder()
                    .setUserId(uid)
                    .build()
                mRewardedAd?.setServerSideVerificationOptions(options)
            }
        })
    }

    private fun showAd(){
        if (mRewardedAd != null) {
            mRewardedAd!!.show(this) {}
        } else {
            Toast.makeText(this@MainActivity, getString(R.string.adNotReady), Toast.LENGTH_SHORT).show()
        }
    }

    private fun setupOnesignal(){
        OneSignal.setLogLevel(OneSignal.LOG_LEVEL.VERBOSE, OneSignal.LOG_LEVEL.NONE);
        OneSignal.initWithContext(this);
        OneSignal.setAppId("765383f8-e489-4722-b078-30bdcbc5010d");
    }

    fun getDate(timestamp: Long): Calendar {
        val calendar = Calendar.getInstance(Locale.ENGLISH)
        calendar.timeInMillis = timestamp * 1000L
        return calendar
    }

    override fun onAcknowledgePurchaseResponse(billingResult: BillingResult) {
        if (billingResult.responseCode == BillingClient.BillingResponseCode.OK) {
            Log.d("Subscription: ", "Checked")
        }
    }

}