package com.roid.bettingtips

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import com.google.firebase.auth.ktx.auth
import com.google.firebase.ktx.Firebase

class SplashActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_splash)

        val user = Firebase.auth.currentUser
        if (user != null) {
            startMain()
        } else {
            createSignInIntent()
        }
    }

    private fun createSignInIntent() {
        val intent = Intent(baseContext, SignActivity::class.java)
        startActivity(intent)
        finish()
    }

    private fun startMain(){
        val background = object : Thread() {
            override fun run() {
                try {
                    sleep(1000)
                    val intent = Intent(baseContext, MainActivity::class.java)
                    startActivity(intent)
                    finish()
                }catch (e: Exception){
                    e.printStackTrace()
                }
            }
        }
        background.start()
    }
}