package com.roid.bettingtips.adapters

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.roid.bettingtips.ItemClickListener
import com.roid.bettingtips.data.CatData
import com.roid.bettingtips.R

class RCAdapterWon (var data: MutableList<CatData>, var activity: Activity, val itemClickListener: ItemClickListener) : RecyclerView.Adapter<RCAdapterWon.ViewHolder>() {

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var leagueName: TextView = itemView.findViewById(R.id.leagueName)
        var teamOne: TextView = itemView.findViewById(R.id.teamOne)
        var teamTwo: TextView = itemView.findViewById(R.id.teamTwo)
        var infoText: TextView = itemView.findViewById(R.id.infoText)
        var dateText: TextView = itemView.findViewById(R.id.date)
        var teamOneScore: TextView = itemView.findViewById(R.id.teamOneScore)
        var teamTwoScore: TextView = itemView.findViewById(R.id.teamTwoScore)
        var priceText: TextView = itemView.findViewById(R.id.priceText)
        var ratioText: TextView = itemView.findViewById(R.id.ratioText)
        var resultImage: ImageView = itemView.findViewById(R.id.result_img)
        var macText: TextView = itemView.findViewById(R.id.cattext)
        var buyLy: RelativeLayout = itemView.findViewById(R.id.buyLy)
        var scoreLy: RelativeLayout = itemView.findViewById(R.id.scoreLy)
        var ovun: String = "Ovun Bu"

        init{
            buyLy.setOnClickListener{itemClickListener.onClick(data[adapterPosition].id, data[adapterPosition].price, data[adapterPosition].result)}
        }
    }

    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): ViewHolder {
        val v = LayoutInflater.from(viewGroup.context).inflate(R.layout.item_won, viewGroup, false)
        return ViewHolder(v)
    }

    override fun onBindViewHolder(v: ViewHolder, i: Int) {
        v.leagueName.text = data[i].leagueName
        v.teamOne.text = data[i].teamOne
        v.teamTwo.text = data[i].teamTwo
        v.dateText.text = data[i].date
        v.dateText.text = data[i].date


        if(data[i].price > 0){
            if(data[i].userBought == 0){
                v.buyLy.visibility = View.VISIBLE
                v.scoreLy.visibility = View.GONE
                v.priceText.text = data[i].price.toString()
                v.teamOneScore.text =  "-"
                v.teamTwoScore.text =  "-"
                v.ratioText.text = "Locked"
                v.infoText.text = "Locked"
            }else{
                v.scoreLy.visibility = View.VISIBLE
                v.buyLy.visibility = View.GONE
                v.teamOneScore.text =  data[i].teamOneScore
                v.teamTwoScore.text =  data[i].teamTwoScore
                v.ratioText.text = data[i].ratio
                v.infoText.text = data[i].info
            }
        }else{
            v.infoText.text = data[i].info
            v.teamOneScore.text =  data[i].teamOneScore
            v.teamTwoScore.text =  data[i].teamTwoScore
            v.ratioText.text = data[i].ratio
        }

        when(data[i].result){
            0 -> v.resultImage.setImageResource(R.drawable.ic_question)
            1 -> v.resultImage.setImageResource(R.drawable.ic_tick)
            2 -> v.resultImage.setImageResource(R.drawable.ic_wrong)
        }

        when (data[i].mac_cat){
            "1" -> v.macText.text = data[i].ovun
            "2" -> v.macText.text = data[i].HtFt
            "3" -> v.macText.text = data[i].Odds
            "4" -> v.macText.text = data[i].plats
            "1,2,3,4" -> v.macText.text = data[i].all
            "1,3,4" -> v.macText.text = data[i].i134
            "1,2,4" -> v.macText.text = data[i].i124
            "1,2,3" -> v.macText.text = data[i].i123
            "2,3,4" -> v.macText.text = data[i].i234
            "1,2" -> v.macText.text = data[i].i12
            "1,3" -> v.macText.text = data[i].i13
            "1,4" -> v.macText.text = data[i].i14
            "2,3" -> v.macText.text = data[i].i23
            "2,4" -> v.macText.text = data[i].i24
            "3,4" -> v.macText.text = data[i].i34

        }

    }



    override fun getItemCount(): Int {
        return data.size
    }


}

