package com.roid.bettingtips.pages

import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.Toast
import com.google.firebase.auth.ktx.auth
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.ValueEventListener
import com.google.firebase.database.ktx.database
import com.google.firebase.ktx.Firebase
import com.roid.bettingtips.*
import java.util.*

class ShopFragment : Fragment(), PurchaseDialogListener, PurchaseWandListener {
    private lateinit var database: DatabaseReference
    private var purchaseDialog: PurchaseDialog = PurchaseDialog(this)
    private var purchaseWandDialog: PurchaseWandDialog = PurchaseWandDialog(this)
    private var itemToSub = 0
    private var isOvunSub = false
    private var isHtftSub = false
    private var isOddsSub = false
    private var isPlatSub = false

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v = inflater.inflate(R.layout.fragment_shop, container, false)

        database = Firebase.database.reference
        val user = Firebase.auth.currentUser

        val buyMagicalWandBtn = v.findViewById<Button>(R.id.buyDiamondBtn)
        val buyOvunBtn = v.findViewById<Button>(R.id.ovunBtn)
        val buyHtftBtn = v.findViewById<Button>(R.id.htftBtn)
        val buyOddsBtn = v.findViewById<Button>(R.id.oddsBtn)
        val buyPlatBtn = v.findViewById<Button>(R.id.platBtn)
        val buyPacket1Btn = v.findViewById<Button>(R.id.packet1btn)
        val buyPacket2Btn = v.findViewById<Button>(R.id.packet2btn)

        if (user != null) {
            val ordersRef = database.child("users").child(user.uid)
            val valueEventListener = object : ValueEventListener {
                override fun onDataChange(dataSnapshot: DataSnapshot) {
                    val ovun =  dataSnapshot.child("ovun").value.toString().toLong()
                    val htft = dataSnapshot.child("htft").value.toString().toLong()
                    val odds = dataSnapshot.child("twoh").value.toString().toLong()
                    val plat = dataSnapshot.child("plat").value.toString().toLong()

                    if(Calendar.getInstance() < getDate(ovun)){
                        isOvunSub = true
                    }

                    if(Calendar.getInstance() < getDate(htft)){
                        isHtftSub = true
                    }

                    if(Calendar.getInstance() < getDate(odds)){
                        isOddsSub = true
                    }

                    if(Calendar.getInstance() < getDate(plat)){
                        isPlatSub = true
                    }
                }

                override fun onCancelled(databaseError: DatabaseError) {
                    Log.d("Data", databaseError.message)
                }
            }
            ordersRef.addValueEventListener(valueEventListener)
        } else {
            val intent = Intent(activity, SplashActivity::class.java)
            startActivity(intent)
            activity?.finish()
        }

        buyOvunBtn.setOnClickListener(){
            if(isOvunSub){
                Toast.makeText(activity, getString(R.string.alreadySub), Toast.LENGTH_LONG).show()
            }else{
                itemToSub = 0
                if(!purchaseDialog.isAdded){
                    fragmentManager?.let { purchaseDialog.show(it, "purchaseDialog") }
                }
            }

        }

        buyHtftBtn.setOnClickListener(){
            if(isHtftSub){
                Toast.makeText(activity, getString(R.string.alreadySub), Toast.LENGTH_LONG).show()
            }else{
                itemToSub = 1
                if(!purchaseDialog.isAdded){
                    fragmentManager?.let { purchaseDialog.show(it, "purchaseDialog") }
                }
            }
        }

        buyOddsBtn.setOnClickListener(){
            if(isOddsSub){
                Toast.makeText(activity, getString(R.string.alreadySub), Toast.LENGTH_LONG).show()
            }else{
                itemToSub = 2
                if(!purchaseDialog.isAdded){
                    fragmentManager?.let { purchaseDialog.show(it, "purchaseDialog") }
                }
            }
        }

        buyPlatBtn.setOnClickListener(){
            if(isPlatSub){
                Toast.makeText(activity, getString(R.string.alreadySub), Toast.LENGTH_LONG).show()
            }else{
                itemToSub = 3
                if(!purchaseDialog.isAdded){
                    fragmentManager?.let { purchaseDialog.show(it, "purchaseDialog") }
                }
            }
        }

        buyMagicalWandBtn.setOnClickListener(){
            if(!purchaseWandDialog.isAdded){
                fragmentManager?.let { purchaseWandDialog.show(it, "purchaseWandDialog") }
            }
        }

        buyPacket1Btn.setOnClickListener(){
            if(isOddsSub || isPlatSub){
                Toast.makeText(activity, getString(R.string.alreadySubPacket), Toast.LENGTH_LONG).show()
            }else{
                (activity as MainActivity).purchase("packet1")
            }
        }

        buyPacket2Btn.setOnClickListener(){
            if(isOddsSub || isPlatSub || isOvunSub || isHtftSub){
                Toast.makeText(activity, getString(R.string.alreadySubPacket), Toast.LENGTH_LONG).show()
            }else{
                (activity as MainActivity).purchase("packet2")
            }
        }


        return v
    }

    override fun onClick(sub_id: Int) {
        var subTime = "_1m"
        var subItem = "ovun"

        when(sub_id){
            0 -> subTime = "_1m"
            1 -> subTime = "_3m"
            2 -> subTime = "_6m"
            3 -> subTime = "_1y"
        }

        when(itemToSub){
            0 -> subItem = "ovun"
            1 -> subItem = "htft"
            2 -> subItem = "odds"
            3 -> subItem = "plat"
        }

        (activity as MainActivity).purchase(subItem + subTime)

    }

    override fun onClickPurchase(buy_id: Int) {
        when(buy_id){
            0 -> (activity as MainActivity).purchase("dia100")
            1 -> (activity as MainActivity).purchase("dia500")
            2 -> (activity as MainActivity).purchase("dia1000")
            3 -> (activity as MainActivity).purchase("dia5000")
            4 -> (activity as MainActivity).purchase("dia10000")
        }
    }

    fun getDate(timestamp: Long): Calendar {
        val calendar = Calendar.getInstance(Locale.ENGLISH)
        calendar.timeInMillis = timestamp * 1000L
        return calendar
    }
}