<?php
require("include/conn.php");
ob_start();
session_start();
if(isset($_SESSION["s_username"],$_SESSION["s_pass"])){ 
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">    
	<title>RoidBett - Betting Panel</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-2.css" rel="stylesheet">
    <link rel="stylesheet" href="css/toastr.min.css"crossorigin="anonymous">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-danger sidebar sidebar-dark accordion" id="accordionSidebar">
            <!-- Sidebar - Brand -->
            <div class="text-center" style="margin:15px">
                <img src="img/logo.png" style="max-width:80px"/>
            </div>

            <div class="sidebar-heading">
                Prediction
            </div>

            <li class="nav-item">
                <a class="nav-link" href="betting.php">
                    <i class="fas fa-futbol"></i>
                    <span>Prediction</span>
                </a>
            </li>

            <li class="nav-item active">
                <a class="nav-link" href="addbetting.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add Prediction</span>
                </a>
            </li>            <hr class="sidebar-divider">
            <div class="sidebar-heading">
                NEWS
            </div>

            <li class="nav-item" active>
                <a class="nav-link" href="news.php">
                    <i class="fas fa-futbol"></i>
                    <span>News</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="addnews.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add News</span>
                </a>
            </li>
            <hr class="sidebar-divider">
     <li class="nav-item">
                <a class="nav-link" href="setting.php">
                    <i class="fas fa-cog"></i>
                    <span>Social Setting</span>
                </a>
            </li>
						
            <hr class="sidebar-divider">
            <div class="sidebar-heading">
                Users
            </div>

            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-user"></i>
                    <span>User List</span>
                </a>
            </li>

 

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>



        </ul>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Navbar -->
                    <ul class="navbar-nav ml-auto">
    
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo($_SESSION["s_username"]); ?></span>
                                <img class="img-profile rounded-circle"
                                    src="img/undraw_profile.svg">
                            </a>
    
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                aria-labelledby="userDropdown">
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#usettingsModal">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    User Setting
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Log Out
                                </a>
                            </div>
                        </li>
                    </ul>
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <h1 class="h3 mb-4 text-gray-800">Add Prediction</h1>
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Add Prediction</h6>
                        </div>
                        <div class="card-body">
                            <div class="container tahmin">
                                <table class="text-center" style="margin-bottom:20px;width:100%;">
                                    <tr>
                                      <td>
                                           <div class="form-check" style="margin-right:10px;">
                                               <input type="checkbox" class="form-check-input" id="freeCheck">
                                               <label class="form-check-label" for="freeCheck">Free</label>
                                           </div>
                                        </td>
                                        <td>
                                           <div class="form-check" style="margin-right:10px;">
                                               <input type="checkbox" class="form-check-input" id="paidCheck">
                                               <label class="form-check-label" for="paidCheck">Paid</label>
                                           </div>
                                        </td>
                                        <td>
                                           <div class="form-check" style="margin-right:10px;">
                                               <input type="checkbox" class="form-check-input" id="ovunCheck">
                                               <label class="form-check-label" for="ovunCheck">Ov/Un</label>
                                           </div>
                                        </td>
                                        <td>
                                           <div class="form-check" style="margin-right:10px;">
                                               <input type="checkbox" class="form-check-input" id="htftCheck">
                                               <label class="form-check-label" for="htftCheck">Ht/Ft</label>
                                           </div>
                                        </td>
                                        <td>
                                           <div class="form-check" style="margin-right:10px;">
                                               <input type="checkbox" class="form-check-input" id="oddsCheck">
                                               <label class="form-check-label" for="oddsCheck">+150 Odds</label>
                                           </div>
                                        </td>
                                        <td>
                                           <div class="form-check">
                                               <input type="checkbox" class="form-check-input" id="platCheck">
                                               <label class="form-check-label" for="platCheck">Plat</label>
                                           </div>
                                        </td>
                                    </tr>
                                </table>
                                <input type="number" id="price" class="form-control" placeholder="Paid ?"/>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" id="leagueName" class="form-control" placeholder="League Name"/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" id="leagueNameEn" class="form-control" placeholder="League Name (Differend Language)"/>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="form-check">
                                       <input class="form-check-input" type="checkbox" id="engTeamNameCheck">
                                       <label class="form-check-label" for="engTeamNameCheck">
                                         Differend Language Team Name
                                       </label>
                                     </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" id="teamOne" class="form-control" placeholder="Team 1"/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" id="teamTwo" class="form-control" placeholder="Team 2"/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" id="teamOneEn" class="form-control" placeholder="Team 1 (Differend Lang.)" disabled/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" id="teamTwoEn" class="form-control" placeholder="Team 2 (Differend Lang.)" disabled/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="number" id="teamOneScore" class="form-control" placeholder="Team 1 Score"/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" id="teamTwoScore" class="form-control" placeholder="Team 2 Score"/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" id="date" class="form-control" placeholder="Date"/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" id="time" class="form-control" placeholder="Time"/>
                                    </div>
                                </div>                          

                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="text" id="info" class="form-control" placeholder="Match Prediction"/>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" id="infoEn" class="form-control" placeholder="Match Prediction (Differend Lang.)"/>
                                    </div>
                                </div>   
                                <input type="text" id="ratio" class="form-control" placeholder="Rate"/>
                                <button id="saveBtn" class="btn btn-success">Save</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Betting v1.0 2022</span>
                    </div>
                </div>
            </footer>

        </div>


    </div>

    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Log out</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Are you sure you want to log out?</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="logout.php">Ok</a>
                </div>
            </div>
        </div>
    </div>

    <?php include("include/userSettingsModal.php"); ?>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sweetalert2.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="js/toastr.min.js" crossorigin="anonymous"></script>
    <script src="js/modalSaveUser.js"></script>
    <script type="text/javascript">
        $('#saveBtn').click(function(event) {
            var vipIds = [];
            var price = "0";
            var vip_data = "0";
            
            
            if($("#paidCheck").is(':checked')){
                price = $("#price").val();
            }else{
                price = "0";
            }
            

            if($("#freeCheck").is(':checked')){
                vip_data = "0";
            }else{
                 if($('#ovunCheck').is(':checked') == false && $('#htftCheck').is(':checked') == false && $('#oddsCheck').is(':checked') == false && $('#platCheck').is(':checked') == false){
                     vip_data = "0";
                 }else{
                     if($('#ovunCheck').is(':checked') == true){vipIds.push("1");}
                     if($('#htftCheck').is(':checked') == true){vipIds.push("2");}
                     if($('#oddsCheck').is(':checked') == true){vipIds.push("3");}
                     if($('#platCheck').is(':checked') == true){vipIds.push("4");}
                     vip_data = vipIds.join(",");
                 }
            

            }

            
            var leagueName = $("#leagueName").val();
            var leagueNameEn = $("#leagueNameEn").val();
            var teamOne = $("#teamOne").val();
            var teamTwo = $("#teamTwo").val();
            var teamOneEn = $("#teamOneEn").val();
            var teamTwoEn = $("#teamTwoEn").val();
            var date = $("#date").val() + " - " + $("#time").val();
            var teamOneScore = $("#teamOneScore").val();
            var teamTwoScore = $("#teamTwoScore").val();
            var info = $("#info").val();
            var infoEn = $("#infoEn").val();
            var ratio = $("#ratio").val();
            

            if(price != "" || vip_data != "" || leagueName != "" || leagueNameEn != "" || teamOne != "" || teamTwo != "" || teamOneEn != "" || teamTwoEn != "" || date != "" || teamOneScore != "" || teamTwoScore != "" || info != "" || infoEn != "" || ratio != ""){
                $("#saveBtn").html('<div class="spinner-border spinner-border-sm m-2" role="status"><span class="sr-only">Loading...</span></div>');
                $.ajax({
                   url: "include/addMac.php", 
                   type: "POST",             
                   data: {"price": price, "vip_data": vip_data, "leagueName": leagueName, "leagueNameEn": leagueNameEn, "teamOne": teamOne, "teamTwo": teamTwo,"teamOneEn": teamOneEn, "teamTwoEn": teamTwoEn, "date": date, "teamOneScore": teamOneScore, "teamTwoScore": teamTwoScore, "info": info, "infoEn": infoEn, "ratio": ratio},
                   success: function(data) {
                    console.log(data);
                       if(data == "success"){
                           toastr["success"]("Success", "It Saved !");
                           setTimeout(function () {location.reload(true); }, 2000);
                       }else if(data == "null_post"){
                           toastr["info"]("Please do not leave blank", "Error");
                       }
                       $("#saveBtn").html('Save');
                   },
                   error: function(xhr,textStatus,err){
                       console.log("readyState: " + xhr.readyState);
                       console.log("responseText: "+ xhr.responseText);
                       console.log("status: " + xhr.status);
                       console.log("text status: " + textStatus);
                       console.log("error: " + err);
                       $("#saveBtn").html('<div class="m-2" role="status">Something went wrong !</div>');
                   }
                });
            }else{
                toastr["info"]("Please fill in your blanks", "Error");
            }

        });
        
         $(document).ready(function(){
            $("#price").hide();
             
            $("#freeCheck").change(function() {
                if(this.checked) {
                   $("#paidCheck").prop( "checked", false );
                   $("#ovunCheck").prop( "checked", false );
                   $("#htftCheck").prop( "checked", false );
                   $("#oddsCheck").prop( "checked", false );
                   $("#platCheck").prop( "checked", false );
                   $("#price").hide();
                }
            });
            
            $("#paidCheck").change(function() {
                if(this.checked) {
                   $("#freeCheck").prop( "checked", false );
                   $("#price").show();
                }else{
                   $("#price").hide();
                }
            });
            
            $("#ovunCheck").change(function() {
                if(this.checked) {
                   $("#freeCheck").prop( "checked", false );
                }
            
            });
            
            $("#htftCheck").change(function() {
                if(this.checked) {
                   $("#freeCheck").prop( "checked", false );
                }
            });
            
            $("#oddsCheck").change(function() {
                if(this.checked) {
                   $("#freeCheck").prop( "checked", false );
                }
            });
            
            $("#platCheck").change(function() {
                if(this.checked) {
                   $("#freeCheck").prop( "checked", false );
                }
            });
            
            $("#engTeamNameCheck").change(function() {
                if(this.checked) {
                   $("#teamOneEn").prop( "disabled", false );
                   $("#teamTwoEn").prop( "disabled", false );
                }else{
                   $("#teamOneEn").prop( "disabled", true );
                   $("#teamTwoEn").prop( "disabled", true );
                   $("#teamOneEn").val($("#teamOne").val());
                   $("#teamTwoEn").val($("#teamTwo").val());
                }
            });
            
            $("#teamOne").on('keyup', function(event) {
                if($("#engTeamNameCheck").prop('checked') == false){
                    $("#teamOneEn").val($("#teamOne").val());
                }
            });
            
            $("#teamTwo").on('keyup', function(event) {
                if($("#engTeamNameCheck").prop('checked') == false){
                    $("#teamTwoEn").val($("#teamTwo").val());
                }
            });
            
	        $('#date').bind('keyup','keydown', function(event) {
  	          var inputLength = event.target.value.length;
              if (event.keyCode != 8){
                if(inputLength === 2 || inputLength === 5){
                  var thisVal = event.target.value;
                  thisVal += '.';
                  $(event.target).val(thisVal);
    	        }
              }
            })

	        $('#time').bind('keyup','keydown', function(event) {
  	          var inputLength = event.target.value.length;
              if (event.keyCode != 8){
                if(inputLength === 2){
                  var thisVal = event.target.value;
                  thisVal += '.';
                  $(event.target).val(thisVal);
    	        }
              }
            })
            
         });

    </script>

</body>

</html>

<?php }else{header("Location: login.php");} ?>