<?php
require("include/conn.php");
ob_start();
session_start();
if(isset($_SESSION["s_username"],$_SESSION["s_pass"])){ 

  $page = 1;
  if(isset($_GET["page"])){
       $page = $_GET["page"];
  }

  $falCount = $pdo->query("SELECT COUNT(*) FROM mac_data")->fetchColumn();
  $showPerPage = 10;
  $pageConut = ceil($falCount / $showPerPage);
                                            
  if($page < 1) $page = 1;
  if($page > $pageConut){
    $page = (int)$pageConut;
  }

  $limit = ($page - 1) * $showPerPage;
  $faldata = $pdo->prepare("SELECT * FROM mac_data ORDER BY id DESC LIMIT :basla, :bitir ");
  $faldata->bindValue(":basla",$limit,PDO::PARAM_INT);
  $faldata->bindValue(":bitir",$showPerPage,PDO::PARAM_INT);
  $faldata->execute();
  $falList = $faldata->fetchAll(PDO::FETCH_OBJ);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>RoidBett - Betting Panel</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-2.css" rel="stylesheet">
    <link rel="stylesheet" href="css/toastr.min.css"crossorigin="anonymous">
    <style>
        .tag{display:block;padding-left:9px;padding-right:9px;color:#fff;border-radius:100px;margin:2px;font-size:12px;text-align:center;}
    </style>
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-danger sidebar sidebar-dark accordion" id="accordionSidebar">
            <!-- Sidebar - Brand -->
            <div class="text-center" style="margin:15px">
                <img src="img/logo.png" style="max-width:80px"/>
            </div>

            <div class="sidebar-heading">
                Prediction
            </div>

            <li class="nav-item active">
                <a class="nav-link" href="betting.php">
                    <i class="fas fa-futbol"></i>
                    <span>Prediction</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="addbetting.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add Prediction</span>
                </a>
            </li>            <hr class="sidebar-divider">
			 <div class="sidebar-heading">
                NEWS
            </div>

            <li class="nav-item" active>
                <a class="nav-link" href="news.php">
                    <i class="fas fa-futbol"></i>
                    <span>News</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="addnews.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add News</span>
                </a>
            </li>
            <hr class="sidebar-divider">
     <li class="nav-item">
                <a class="nav-link" href="setting.php">
                    <i class="fas fa-cog"></i>
                    <span>Social Setting</span>
                </a>
            </li>
						
            <hr class="sidebar-divider">

            <div class="sidebar-heading">
                Users
            </div>

            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-user"></i>
                    <span>User List</span>
                </a>
            </li>

          

      

        </ul>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Navbar -->
                    <ul class="navbar-nav ml-auto">
    
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo($_SESSION["s_username"]); ?></span>
                                <img class="img-profile rounded-circle"
                                    src="img/undraw_profile.svg">
                            </a>
    
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                aria-labelledby="userDropdown">
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#usettingsModal">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    User Setting
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Log Out
                                </a>
                            </div>
                        </li>
                    </ul>
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <h1 class="h3 mb-4 text-gray-800">Prediction</h1>
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Prediction</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" id="all"/> ID</th>
                                            <th>League</th>
                                            <th>Teams</th>
                                            <th>Prediction-Rate</th>
                                            <th>Category</th>
                                            <th>Date-Time</th>
                                            <th>Result</th>
                                            <th>Process</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            foreach($falList as $item){
                                                $price = "";
                                                if($item->mac_cat == "0"){
                                                    if($item->price == 0){
                                                        $price = '<b style="color:#2ecc71">Free</b>';
                                                    }else{
                                                        $price = '<b style="font-size: 11px;">Paid : '.$item->price.'</b>';
                                                    }

                                                }else{
                                                    if($item->price > 0){
                                                         $price = $price.'<b  style="font-size: 11px;">Paid : '.$item->price.'</b>';
                                                    }
                                                    $vipIds = explode(",", $item->mac_cat);
                                                
                                                    foreach($vipIds as $vip){
                                                    
                                                       switch($vip){
                                                           case "1":
                                                               $price = $price . '<span class="tag bg-gradient-info">Ov/Un</span>';
                                                               break;
                                                           case "2":
                                                               $price = $price . '<span class="tag bg-gradient-danger">Ht/Ft</span>';
                                                               break;
                                                           case "3":
                                                               $price = $price . '<span class="tag bg-gradient-success">+200</span>';
                                                               break;
                                                           case "4":
                                                               $price = $price . '<span class="tag bg-gradient-primary">Plat</span>';
                                                               break;
                                                       }
                                                    }
                                                }


                                                switch($item->result){
                                                    case 0:
                                                      $result = '<i class="fas fa-hourglass-half"></i>';
                                                      break;
                                                    case 1:
                                                      $result = '<i style="color:#2ecc71" class="fas fa-check-circle"></i>';
                                                      break;
                                                    case 2:
                                                      $result = '<i style="color:#e74c3c" class="fas fa-times-circle"></i>';
                                                      break;
                                                    default:
                                                      $result = '<i class="fas fa-hourglass-half"></i>';

                                                }

                                                if($item->price == 0)
                                                echo '<tr>';
                                                echo '<td><input type="checkbox" id="'.$item->id.'"/> '.$item->id.'</td>';
                                                echo '<td>'.$item->leagueName.'</td>';
                                                echo '<td>'.$item->teamOne.' - '.$item->teamTwo.'</td>';
                                                echo '<td>'.$item->teamOneScore.'/'.$item->teamTwoScore.' - '.$item->ratio.'</td>';
                                                echo '<td>'.$price.'</td>';
                                                echo '<td>'.$item->date.'</td>';
                                                echo '<td class="text-center">'.$result.'</td>';
                                                echo '
                                                 <td class="text-center">
                                                     <a href="javascript:setItem('.$item->id.',1)" class="btn btn-success btn-circle btn-sm">
                                                       <i class="fas fa-check"></i>
                                                     </a>
                                                     <a href="javascript:setItem('.$item->id.',2)" class="btn btn-warning btn-circle btn-sm">
                                                       <i class="fas fa-times"></i>
                                                     </a>
                                                     <a href="javascript:delItem('.$item->id.')" class="btn btn-danger btn-circle btn-sm">
                                                       <i class="fas fa-trash"></i>
                                                     </a>
                                                     <a href="editbetting.php?id='.$item->id.'" class="btn btn-info btn-circle btn-sm">
                                                       <i class="fas fa-pen"></i>
                                                     </a>
                                                 </td>';
                                                echo '</tr>';
                                            }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                            <form id="selectedItemsForm">
                                <nav aria-label="page">
                                <ul class="pagination">
                                    <?php for($i = 1; $i<=$pageConut;$i++){ ?>
                                    <li class="page-item"><a class="page-link <?php if($page == $i){echo 'active';} ?>" href="betting.php?page=<?php echo $i;?>"><?php echo $i;?></a></li>
                                    <?php } ?>
                                </ul>
                                </nav>
                               <table>
                                   <tr>
                                       <td>
                                         <select id="selectedItems" class="form-select" aria-label="İşlemler">
                                           <option value="1">Mark as won</option>
                                           <option value="2">Mark as not won</option>
                                           <option value="3">Delete</option>
                                           <option value="0">Reset Status</option>
                                         </select>
                                       </td>
                                       <td><button id="selectedFormBtn" type="submit" class="btn btn-primary">Go</button></td>
                                   </tr>
                               </table>
                            </form>

                        </div>
                    </div>

                </div>

            </div>
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Betting v1.0 - 2022</span>
                    </div>
                </div>
            </footer>

        </div>


    </div>

    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Log Out</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Are you sure you want to log out?</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="logout.php">Ok</a>
                </div>
            </div>
        </div>
    </div>

    <?php include("include/userSettingsModal.php"); ?>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sweetalert2.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="js/toastr.min.js" crossorigin="anonymous"></script>
    <script src="js/modalSaveUser.js"></script>

    <script type="text/javascript">

$('#all').change(function() {
    if ($(this).is(':checked')) {
        selectAll();
    } else {
        deselectAll();
    }
});

function selectAll() {
    $("#dataTable input:checkbox").prop("checked", true);
}

function deselectAll() {
    $("#dataTable input:checkbox").prop("checked", false);
}

function setItem(id, result) {
    $.ajax({
        url: "include/setItem.php",
        type: "POST",
        data: {
            "id": id,
            "result": result
        },

        success: function(data) {
            console.log(data);
            if (data == "success") {
                toastr["success"]("Success", "It Saved !");
                setTimeout(function() {
                    location.reload(true);
                }, 2000);
            }
        },
        error: function(xhr, textStatus, err) {
            console.log("readyState: " + xhr.readyState);
            console.log("responseText: " + xhr.responseText);
            console.log("status: " + xhr.status);
            console.log("text status: " + textStatus);
            console.log("error: " + err);
        }
    });
}

function delItem(id) {
    Swal.fire({
        title: 'Are you sure you want to delete the match?',
        showCancelButton: true,
        icon: 'warning',
        confirmButtonColor: '#E02D1B',
        confirmButtonText: 'Delete',
        cancelButtonText: 'Cancel',
        showLoaderOnConfirm: true,
        preConfirm: () => {
            jQuery.ajax({
                type: 'POST',
                url: './include/delMacData.php',
                data: {
                    "id": id
                }
            });
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            let timerInterval
            Swal.fire({
                title: 'Record Delete!',
                html: 'Registrations will be renewed in 1 second.',
                timer: 1000,
                timerProgressBar: true,
                showCancelButton: false,
                didOpen: () => {
                    Swal.showLoading()
                },
                willClose: () => {
                    clearInterval(timerInterval)
                }
            }).then((result) => {
                setTimeout(function() {
                    location.reload(true);
                }, 1000);
            })
        }
    });
}

$("#selectedItemsForm").submit(function(event) {
    if ($("#selectedItems").val() != null) {
        if ($("#selectedItems").val() == 3) {

            var selected = [];
            $('#dataTable input:checked').each(function() {
                if ($(this).attr('id') != "all") {
                    selected.push($(this).attr('id'));
                }

            });

            Swal.fire({
                title: 'Are you sure you want to delete matches?',
                showCancelButton: true,
                icon: 'warning',
                confirmButtonColor: '#E02D1B',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Cancel',
                showLoaderOnConfirm: true,
                preConfirm: () => {
                    jQuery.ajax({
                        type: 'POST',
                        url: './include/delMacData.php',
                        data: {
                            "ids": selected.join(", ")
                        }
                    });
                },
                allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    let timerInterval
                    Swal.fire({
                        title: 'Record Delete !',
                        html: 'Registrations will be renewed in 1 second.',
                        timer: 1000,
                        timerProgressBar: true,
                        showCancelButton: false,
                        didOpen: () => {
                            Swal.showLoading()
                        },
                        willClose: () => {
                            clearInterval(timerInterval)
                        }
                    }).then((result) => {
                        setTimeout(function() {
                            location.reload(true);
                        }, 1000);
                    })
                }
            });

        } else {
            var selected = [];
            $('#dataTable input:checked').each(function() {
                if ($(this).attr('id') != "all") {
                    selected.push($(this).attr('id'));
                }

            });
            var result = $("#selectedItems").val();
            $.ajax({
                url: "include/setItem.php",
                type: "POST",
                data: {
                    "ids": selected.join(", "),
                    "result": result
                },

                success: function(data) {
                    console.log(data);
                    if (data == "success") {
                        toastr["success"]("Success", "It Saved!");
                        setTimeout(function() {
                            location.reload(true);
                        }, 2000);
                    }
                },
                error: function(xhr, textStatus, err) {
                    console.log("readyState: " + xhr.readyState);
                    console.log("responseText: " + xhr.responseText);
                    console.log("status: " + xhr.status);
                    console.log("text status: " + textStatus);
                    console.log("error: " + err);
                    $("#save").html('<div class="m-2" role="status">Something went wrong !</div>');
                }
            });
        }

    }

    event.preventDefault();
});

    </script>
</body>
</html>

<?php }else{header("Location: login.php");} ?>