var http = require('http');
var fs = require("fs");
var url = require('url');
var mysql = require('mysql');
var express = require('express');
var app = express();
var admin = require("firebase-admin");
const admobSSV = require('admob-rewarded-ads-ssv');
var Verifier = require('google-play-billing-validator');
var postPerPage = 8;
var validationRetryCount = 2;
var serverToken = process.env.token;

var serviceAccount = require("./Firebase-AdminSDK-folder.json");
var dotenv = require('dotenv');


admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "Firebase Realtime Database link"
});
/* Google Console -> Create service account / E-mail and Key */
var options = {
    "email": 'validator@pc-api-***********.iam.gserviceaccount.com',
    "key": "-----BEGIN PRIVATE KEY-----\***************\n-----END PRIVATE KEY-----\n",
};
/* Google Console -> Create service account / E-mail and Key *******/
const {
    resourceLimits
} = require('worker_threads');

var db_config = {
    host: process.env.host,
    user: process.env.user,
    password: process.env.pass,
    database: process.env.db
};

var con;

function handleDisconnect() {
  con = mysql.createConnection(db_config); 

  con.connect(function(err) {
    if(err) {
      console.log('error when connecting to db:', err);
      setTimeout(handleDisconnect, 2000); 
    }                                     
  }); 

  con.on('error', function(err) {
    console.log('db error', err);
    if(err.code === 'PROTOCOL_CONNECTION_LOST') {
      handleDisconnect();
    } else {
      throw err;
    }
  });
}

handleDisconnect();
app.get("/", (req,res) =>{
    res.status(200).send({message:'Working...'})
});


app.get('/getNewsData/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var page = req.params.page;
    var lang = req.params.lang;

    if (page != null && lang != null) {
        const startIndex = (page - 1) * postPerPage;
        const endIndex = page * postPerPage;

        con.query("SELECT * FROM news_data WHERE price = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, function(err, result, fields) {
            if (err) throw err;
            if (result.length < 1) {
                res.end('{"status":"null_data"}');
            } else {
                res.write('{');
                res.write('"status":"ok",');
                res.write('"data": {');

                for (var i = 0; i < result.length; i++) {
                    var newstext = result[i].newstext;

                    
                    if(lang == "en"){
                        newstext = result[i].newstextEn;

                    }
                    
                    res.write('"' + i + '":{');
                    res.write('"id":"' + result[i].id + '",');
					res.write('"price":"' + result[i].price + '",');
                    res.write('"newstext":"' + newstext + '",');
					res.write('"flag":"' + result[i].flag + '"');
                    res.write('}');
                    if (i != (result.length - 1)) {
                        res.write(",");
                    }
                }
                res.end("} }");
            }
        });

    } else {
        res.end('{"status":"null_request"}');
    }
});


app.get('/getDeneData/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
    var page = req.params.page;
    var lang = req.params.lang;

    if (page != null && lang != null) {
        const startIndex = (page - 1) * postPerPage;
        const endIndex = page * postPerPage;

        con.query("SELECT * FROM den_data WHERE price = 0 AND mac_cat = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, function(err, result, fields) {
            if (err) throw err;
            if (result.length < 1) {
                res.end('{"status":"null_data"}');
            } else {
                res.write('{');
                res.write('"status":"ok",');
                res.write('"data": {');

                for (var i = 0; i < result.length; i++) {
                    var leagueName = result[i].leagueName;
                    var teamOne = result[i].teamOne;
                    var teamTwo = result[i].teamTwo;
                    var info = result[i].info;
                    
                    if(lang == "en"){
                        leagueName = result[i].leagueNameEn;
                        teamOne = result[i].teamOneEn;
                        teamTwo = result[i].teamTwoEn;
                        info = result[i].infoEn;
                    }
                    
                    res.write('"' + i + '":{');
                    res.write('"id":"' + result[i].id + '",');
                    res.write('"price":"' + result[i].price + '",');
                    res.write('"userBought":"0",');
                    res.write('"leagueName":"' + leagueName + '",');
                    res.write('"teamOne":"' + teamOne + '",');
                    res.write('"teamTwo":"' + teamTwo + '",');
                    res.write('"date":"' + result[i].date + '",');
                    res.write('"result":"' + result[i].result + '",');
                    res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                    res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                    res.write('"info":"' + info + '",');
                    res.write('"ratio":"' + result[i].ratio + '"');
                    res.write('}');
                    if (i != (result.length - 1)) {
                        res.write(",");
                    }
                }
                res.end("} }");
            }
        });

    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getFreeData/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
    var page = req.params.page;
    var lang = req.params.lang;

    if (page != null && lang != null) {
        const startIndex = (page - 1) * postPerPage;
        const endIndex = page * postPerPage;

        con.query("SELECT * FROM mac_data WHERE price = 0 AND mac_cat = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, function(err, result, fields) {
            if (err) throw err;
            if (result.length < 1) {
                res.end('{"status":"null_data"}');
            } else {
                res.write('{');
                res.write('"status":"ok",');
                res.write('"data": {');

                for (var i = 0; i < result.length; i++) {
                    var leagueName = result[i].leagueName;
                    var teamOne = result[i].teamOne;
                    var teamTwo = result[i].teamTwo;
                    var info = result[i].info;
                    
                    if(lang == "en"){
                        leagueName = result[i].leagueNameEn;
                        teamOne = result[i].teamOneEn;
                        teamTwo = result[i].teamTwoEn;
                        info = result[i].infoEn;
                    }
                    
                    res.write('"' + i + '":{');
                    res.write('"id":"' + result[i].id + '",');
                    res.write('"price":"' + result[i].price + '",');
                    res.write('"userBought":"0",');
                    res.write('"leagueName":"' + leagueName + '",');
                    res.write('"teamOne":"' + teamOne + '",');
                    res.write('"teamTwo":"' + teamTwo + '",');
                    res.write('"date":"' + result[i].date + '",');
                    res.write('"result":"' + result[i].result + '",');
                    res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                    res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                    res.write('"info":"' + info + '",');
                    res.write('"ratio":"' + result[i].ratio + '"');
                    res.write('}');
                    if (i != (result.length - 1)) {
                        res.write(",");
                    }
                }
                res.end("} }");
            }
        });

    } else {
        res.end('{"status":"null_request"}');
    }
});


app.get('/getPaidData/:token/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var page = req.params.page;
    var lang = req.params.lang;

    if (token != null && page != null && lang != null) {
        admin
            .auth()
            .verifyIdToken(token)
            .then((decodedToken) => {
                const uid = decodedToken.uid;

                var db = admin.database();
                var ref = db.ref("users").child(uid);

                ref.once("value", function(data) {
                    var userData = data.val();
                    var purchasedIDs = String(userData.purchasedIDs);
                    var purchasedIDsAr = purchasedIDs.split(",");
                    
                    const startIndex = (page - 1) * postPerPage;
                    const endIndex = page * postPerPage;

                    con.query("SELECT * FROM mac_data WHERE price > 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, function(err, result, fields) {
                        if (err) throw err;
                        if (result.length < 1) {
                            res.end('{"status":"null_data"}');
                        } else {
                            res.write('{');
                            res.write('"status":"ok",');
                            res.write('"data": {');

                            for (var i = 0; i < result.length; i++) {
                                var ub = 0;
                                var score = 0;
                                var teamOneScore = "-";
                                var teamTwoScore = "-";
                                var ratio = "-";
                                var info = "-";

                                if (purchasedIDsAr.includes("" + result[i].id + "")) {
                                    ub = 1;
                                    teamOneScore = result[i].teamOneScore;
                                    teamTwoScore = result[i].teamTwoScore;
                                    ratio = result[i].ratio;
                                    
                                    if(lang == "en"){
                                        info = result[i].infoEn;
                                    }else{
                                        info = result[i].info;
                                    }
                                }
                    
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                }
                                
                                res.write('"' + i + '":{');
                                res.write('"id":"' + result[i].id + '",');
                                res.write('"price":"' + result[i].price + '",');
                                res.write('"userBought":"' + ub + '",');
                                res.write('"leagueName":"' + leagueName + '",');
                                res.write('"teamOne":"' + teamOne + '",');
                                res.write('"teamTwo":"' + teamTwo + '",');
                                res.write('"date":"' + result[i].date + '",');
                                res.write('"result":"' + result[i].result + '",');
                                res.write('"teamOneScore":"' + teamOneScore + '",');
                                res.write('"teamTwoScore":"' + teamTwoScore + '",');
                                res.write('"info":"' + info + '",');
                                res.write('"ratio":"' + ratio + '"');
                                res.write('}');
                                if (i != (result.length - 1)) {
                                    res.write(",");
                                }
                            }
                            res.end("} }");
                        }
                    });

                });
            }).catch((error) => {
                res.end('{"status":"auth_error"}');
            });
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getWonData/:token/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var page = req.params.page;
    var lang = req.params.lang;

    if (token != null && page != null && lang != null) {
        admin
            .auth()
            .verifyIdToken(token)
            .then((decodedToken) => {
                const uid = decodedToken.uid;

                var db = admin.database();
                var ref = db.ref("users").child(uid);

                ref.once("value", function(data) {
                    var userData = data.val();
                    var purchasedIDs = String(userData.purchasedIDs);
                    var purchasedIDsAr = purchasedIDs.split(",");
                    
                    const startIndex = (page - 1) * postPerPage;
                    const endIndex = page * postPerPage;

                    con.query("SELECT * FROM mac_data WHERE result = 1 AND mac_cat <> 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, function(err, result, fields) {
                        if (err) throw err;
                        if (result.length < 1) {
                            res.end('{"status":"null_data"}');
                        } else {
                            res.write('{');
                            res.write('"status":"ok",');
                            res.write('"data": {');

                            for (var i = 0; i < result.length; i++) {
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                var info = result[i].info;
                    
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                    info = result[i].infoEn;
                                }
                                
                                res.write('"' + i + '":{');
                                res.write('"id":"' + result[i].id + '",');
                                res.write('"price":"0",');
                                res.write('"userBought":"0",');
                                res.write('"leagueName":"' + leagueName + '",');
                                res.write('"teamOne":"' + teamOne + '",');
                                res.write('"teamTwo":"' + teamTwo + '",');
                                res.write('"date":"' + result[i].date + '",');
                                res.write('"result":"' + result[i].result + '",');
                                res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                                res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                                res.write('"info":"' + info + '",');
                                res.write('"ratio":"' + result[i].ratio + '"');
                                res.write('}');
                                if (i != (result.length - 1)) {
                                    res.write(",");
                                }
                            }
                            res.end("} }");
                        }
                    });

                });
            }).catch((error) => {
                res.end('{"status":"auth_error"}');
            });
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getOvunData/:token/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var page = req.params.page;
    var lang = req.params.lang;

    if (token != null && page != null && lang != null) {
        admin
            .auth()
            .verifyIdToken(token)
            .then((decodedToken) => {
                const uid = decodedToken.uid;

                var db = admin.database();
                var ref = db.ref("users").child(uid);

                ref.once("value", function(data) {
                    var userData = data.val();
                    var d = new Date();
                    var todayDate = d.getTime();
                    var dbDate = new Date(userData.ovun * 1000);
                    
                    const startIndex = (page - 1) * postPerPage;
                    const endIndex = page * postPerPage;

                   con.query("SELECT * FROM mac_data WHERE mac_cat LIKE ? AND result = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, ["%1%"] , function(err, result, fields) {
                        if (err) throw err;
                        if (result.length < 1) {
                            res.end('{"status":"null_data"}');
                        } else if(dbDate > todayDate){
                            res.write('{');
                            res.write('"status":"ok",');
                            res.write('"data": {');

                            for (var i = 0; i < result.length; i++) {
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                var info = result[i].info;
                    
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                    info = result[i].infoEn;
                                }
                                
                                res.write('"' + i + '":{');
                                res.write('"id":"' + result[i].id + '",');
                                res.write('"price":"0",');
                                res.write('"userBought":"1",');
                                res.write('"leagueName":"' + leagueName + '",');
                                res.write('"teamOne":"' + teamOne + '",');
                                res.write('"teamTwo":"' + teamTwo + '",');
                                res.write('"date":"' + result[i].date + '",');
                                res.write('"result":"' + result[i].result + '",');
                                res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                                res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                                res.write('"info":"' + info + '",');
                                res.write('"ratio":"' + result[i].ratio + '"');
                                res.write('}');
                                if (i != (result.length - 1)) {
                                    res.write(",");
                                }
                            }
                            res.end("} }");
                        }else{
                             res.end('{"status":"not_vip"}');
                        }
                    });

                });
            }).catch((error) => {
                res.end('{"status":"auth_error"}');
            });
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getHtftData/:token/:lang/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var page = req.params.page;
    var lang = req.params.lang;

    if (token != null && page != null && lang != null) {
        admin
            .auth()
            .verifyIdToken(token)
            .then((decodedToken) => {
                const uid = decodedToken.uid;

                var db = admin.database();
                var ref = db.ref("users").child(uid);

                ref.once("value", function(data) {
                    var userData = data.val();
                    var d = new Date();
                    var todayDate = d.getTime();
                    var dbDate = new Date(userData.htft * 1000);
                    
                    const startIndex = (page - 1) * postPerPage;
                    const endIndex = page * postPerPage;

                   con.query("SELECT * FROM mac_data WHERE mac_cat LIKE ? AND result = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, ["%2%"] , function(err, result, fields) {
                        if (err) throw err;
                        if (result.length < 1) {
                            res.end('{"status":"null_data"}');
                        } else if(dbDate > todayDate){
                            res.write('{');
                            res.write('"status":"ok",');
                            res.write('"data": {');

                            for (var i = 0; i < result.length; i++) {
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                var info = result[i].info;
                    
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                    info = result[i].infoEn;
                                }
                                
                                res.write('"' + i + '":{');
                                res.write('"id":"' + result[i].id + '",');
                                res.write('"price":"0",');
                                res.write('"userBought":"1",');
                                res.write('"leagueName":"' + leagueName + '",');
                                res.write('"teamOne":"' + teamOne + '",');
                                res.write('"teamTwo":"' + teamTwo + '",');
                                res.write('"date":"' + result[i].date + '",');
                                res.write('"result":"' + result[i].result + '",');
                                res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                                res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                                res.write('"info":"' + info + '",');
                                res.write('"ratio":"' + result[i].ratio + '"');
                                res.write('}');
                                if (i != (result.length - 1)) {
                                    res.write(",");
                                }
                            }
                            res.end("} }");
                        }else{
                             res.end('{"status":"not_vip"}');
                        }
                    });

                });
            }).catch((error) => {
                res.end('{"status":"auth_error"}');
            });
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getOddsData/:token/:lang/:page', async (req, res, next) => {
   res.writeHead(200, {
       'Content-Type': 'application/json; charset=utf-8'
   });
   var token = req.params.token;
   var page = req.params.page;
   var lang = req.params.lang;

   if (token != null && page != null && lang != null) {
       admin
           .auth()
           .verifyIdToken(token)
           .then((decodedToken) => {
               const uid = decodedToken.uid;

               var db = admin.database();
               var ref = db.ref("users").child(uid);

               ref.once("value", function(data) {
                   var userData = data.val();
                   var d = new Date();
                   var todayDate = d.getTime();
                   var dbDate = new Date(userData.twoh * 1000);
                   
                   const startIndex = (page - 1) * postPerPage;
                   const endIndex = page * postPerPage;

                   con.query("SELECT * FROM mac_data WHERE mac_cat LIKE ? AND result = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, ["%3%"] , function(err, result, fields) {
                       if (err) throw err;
                       if (result.length < 1) {
                           res.end('{"status":"null_data"}');
                       } else if(dbDate > todayDate){
                           res.write('{');
                           res.write('"status":"ok",');
                           res.write('"data": {');

                           for (var i = 0; i < result.length; i++) {
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                var info = result[i].info;
                    
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                    info = result[i].infoEn;
                                }
                                
                               res.write('"' + i + '":{');
                               res.write('"id":"' + result[i].id + '",');
                               res.write('"price":"0",');
                               res.write('"userBought":"1",');
                               res.write('"leagueName":"' + leagueName + '",');
                               res.write('"teamOne":"' + teamOne + '",');
                               res.write('"teamTwo":"' + teamTwo + '",');
                               res.write('"date":"' + result[i].date + '",');
                               res.write('"result":"' + result[i].result + '",');
                               res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                               res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                               res.write('"info":"' + info + '",');
                               res.write('"ratio":"' + result[i].ratio + '"');
                               res.write('}');
                               if (i != (result.length - 1)) {
                                   res.write(",");
                               }
                           }
                           res.end("} }");
                       }else{
                            res.end('{"status":"not_vip"}');
                       }
                   });

               });
           }).catch((error) => {
               res.end('{"status":"auth_error"}');
           });
   } else {
       res.end('{"status":"null_request"}');
   }
});

app.get('/getPlatData/:token/:lang/:page', async (req, res, next) => {
   res.writeHead(200, {
       'Content-Type': 'application/json; charset=utf-8'
   });
   var token = req.params.token;
   var page = req.params.page;
   var lang = req.params.lang;

   if (token != null && page != null && lang != null) {
       admin
           .auth()
           .verifyIdToken(token)
           .then((decodedToken) => {
               const uid = decodedToken.uid;

               var db = admin.database();
               var ref = db.ref("users").child(uid);

               ref.once("value", function(data) {
                   var userData = data.val();
                   var d = new Date();
                   var todayDate = d.getTime();
                   var dbDate = new Date(userData.plat * 1000);
                   
                   const startIndex = (page - 1) * postPerPage;
                   const endIndex = page * postPerPage;

                   con.query("SELECT * FROM mac_data WHERE mac_cat LIKE ? AND result = 0 ORDER BY id DESC LIMIT " + startIndex + ", " + endIndex, ["%4%"] , function(err, result, fields) {
                       if (err) throw err;
                       if (result.length < 1) {
                           res.end('{"status":"null_data"}');
                       } else if(dbDate > todayDate){
                           res.write('{');
                           res.write('"status":"ok",');
                           res.write('"data": {');

                           for (var i = 0; i < result.length; i++) {
                                var leagueName = result[i].leagueName;
                                var teamOne = result[i].teamOne;
                                var teamTwo = result[i].teamTwo;
                                var info = result[i].info;
                    
                                if(lang == "en"){
                                    leagueName = result[i].leagueNameEn;
                                    teamOne = result[i].teamOneEn;
                                    teamTwo = result[i].teamTwoEn;
                                    info = result[i].infoEn;
                                }
                               res.write('"' + i + '":{');
                               res.write('"id":"' + result[i].id + '",');
                               res.write('"price":"0",');
                               res.write('"userBought":"1",');
                               res.write('"leagueName":"' + leagueName + '",');
                               res.write('"teamOne":"' + teamOne + '",');
                               res.write('"teamTwo":"' + teamTwo + '",');
                               res.write('"date":"' + result[i].date + '",');
                               res.write('"result":"' + result[i].result + '",');
                               res.write('"teamOneScore":"' + result[i].teamOneScore + '",');
                               res.write('"teamTwoScore":"' + result[i].teamTwoScore + '",');
                               res.write('"info":"' + info + '",');
                               res.write('"ratio":"' + result[i].ratio + '"');
                               res.write('}');
                               if (i != (result.length - 1)) {
                                   res.write(",");
                               }
                           }
                           res.end("} }");
                       }else{
                            res.end('{"status":"not_vip"}');
                       }
                   });

               });
           }).catch((error) => {
               res.end('{"status":"auth_error"}');
           });
   } else {
       res.end('{"status":"null_request"}');
   }
});

app.get('/admin/getUserCount/:token', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
     var token = req.params.token;
       
    if (token == serverToken) {
      fs.readFile("counter.txt", "utf-8", (err, data) => {
         if (err) { res.end('{"status":"' + err + '"}'); }else{
             res.end('{"count":' + parseInt(data)  + '}');
         }
      });
    }else{
        res.end('{"status":"non_valid_token"}');
    }
});

app.get('/getId', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    
    res.end('{"id": 1, "register_prize":10}');
});

app.get('/buy/:token/:id', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var id = req.params.id;

    if (token != null && id != null) {
        admin
            .auth()
            .verifyIdToken(token)
            .then((decodedToken) => {
                const uid = decodedToken.uid;

                var db = admin.database();
                var ref = db.ref("users").child(uid);

                ref.once("value", function(data) {
                    var userData = data.val();
                    var purchasedIDs = String(userData.purchasedIDs);
                    var newPids = purchasedIDs + "," + id;
                    
                    con.query("SELECT * FROM mac_data WHERE id = ?",[id] ,function(err, result, fields) {
                        if (err) throw err;
                        if (result.length < 1) {
                            res.end('{"status":"null_data"}');
                        }else{
                            
                            if(userData.credit >= result[0].price){
                               var newCredit = userData.credit - result[0].price;
                               ref.update({"purchasedIDs": newPids, "credit": newCredit}, function(error) {
                                   if (error) {
                                       res.end('{"status":"error"}');
                                   } else {
                                       res.end('{"status":"ok"}');
                                   }
                               });
                            }else{
                                res.end('{"status":"insufficient_credit"}');
                            }
                        }
                    });
                    

                });
            }).catch((error) => {
                res.end('{"status":"auth_error"}');
            });
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/verify_sub/:token/:utoken/:sku', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var sku = req.params.sku;
    var utoken = req.params.utoken;

    await validatePruchase(token, utoken, sku)

    async function validatePruchase(token, utoken, sku) {
        var verifier = new Verifier(options);

        let receipt = {
            packageName: "com.tribunbets.com",
            productId: sku,
            purchaseToken: token
        };

        let promiseData = verifier.verifySub(receipt)

        promiseData.then(function(response) {
            
            var expiryTime = response["payload"]["expiryTimeMillis"];
            var d = new Date();

            var exDateNew = new Date(parseInt(expiryTime,10));
            
            if(exDateNew < d){
                 setVip(utoken, sku, 0);
            }else{
                 var unixExpTime = Math.floor(exDateNew.getTime()/1000);
                 setVip(utoken, sku, unixExpTime);
            }
            
        }).catch(function(error) {
            if (validationRetryCount > 0) {
                validatePruchase(token, utoken, sku);
                validationRetryCount--;
            } else {
                res.end('{"status":"' + JSON.stringify(error) + '"}');
            }
        })
    }

    function setVip(utoken, sku, expTime) {
        if (utoken != null && sku != null && expTime != null) {
            admin
                .auth()
                .verifyIdToken(utoken)
                .then((decodedToken) => {
                    const uid = decodedToken.uid;
                    
                    var db = admin.database();
                    var ref = db.ref("users").child(uid);
                    var setSku = sku;
                    if(expTime == 0){
                        setSku = "0";
                    }

                    if (sku == "ovun_1m" || sku == "ovun_3m" || sku == "ovun_6m" || sku == "ovun_1y") {
                       ref.update({"ovun": expTime, "ovun_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                        
                    }else if (sku == "htft_1m" || sku == "htft_3m" || sku == "htft_6m" || sku == "htft_1y") {
                       ref.update({"htft": expTime, "htft_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                    }else if (sku == "odds_1m" || sku == "odds_3m" || sku == "odds_6m" || sku == "odds_1y") {
                       ref.update({"twoh": expTime, "twoh_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                    }else if (sku == "plat_1m" || sku == "plat_3m" || sku == "plat_6m" || sku == "plat_1y"){
                       ref.update({"plat": expTime, "plat_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                    } else if (sku == "packet1"){
                       ref.update({"twoh": expTime, "plat": expTime, "plat_sku": setSku, "twoh_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                    } else if (sku == "packet2"){
                       ref.update({"ovun": expTime, "ovun_sku": setSku, "htft": expTime, "htft_sku": setSku, "twoh": expTime, "plat": expTime, "plat_sku": setSku, "twoh_sku": setSku}, function(error) {
                          if (error) {
                              res.end('{"status":"error"}');
                          } else {
                              if(expTime == 0){
                                  res.end('{"status":"set_to_zero"}');
                              }else{
                                  res.end('{"status":"renew_ok"}');
                              }
                          }
                       });
                    } else{
                        res.end('{"status":"error"}');
                    }
                    
                }).catch((error) => {
                    res.end('{"status":"auth_error"}');
                });
        } else {
            res.end('{"status":"null_request"}');
        }
    }
});

app.get('/verify_purchase/:token/:utoken/:sku', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8'
    });
    var token = req.params.token;
    var sku = req.params.sku;
    var utoken = req.params.utoken;

    await validatePruchase(token, utoken, sku)

    async function validatePruchase(token, utoken, sku) {
        var verifier = new Verifier(options);

        let receipt = {
            packageName: "com.tribunbets.com",
            productId: sku,
            purchaseToken: token
        };

        let promiseData = verifier.verifyINAPP(receipt)

        promiseData.then(function(response) {
            
            var difference = Date.now() - response.payload.purchaseTimeMillis;
            var differenceInSeconds = difference / 1000;
            var differenceInMinutes = differenceInSeconds / 60;

            if (differenceInMinutes > 3) {
                res.end('{"status":"time_out"}');
            } else {
                giveCredit(utoken, sku);
            }

        }).catch(function(error) {
            if (validationRetryCount > 0) {
                validatePruchase(token, utoken, sku);
                validationRetryCount--;
            } else {
                res.end('{"status":"error"}');
            }
        })
    }

    function giveCredit(utoken, sku) {
        if (utoken != null && sku != null) {
            admin
                .auth()
                .verifyIdToken(utoken)
                .then((decodedToken) => {
                    const uid = decodedToken.uid;
                    var db = admin.database();
                    var ref = db.ref("users").child(uid);

                     ref.once("value", function(data) {
                      var userData = data.val();
                        if (sku == "dia100") {
                            var newCredit = userData.credit += 100;
                            ref.update({"credit": newCredit}, function(error) {
                                if (error) {
                                    res.end('{"status":"error"}');
                                } else {
                                    res.end('{"status":"ok"}');
                                }
                            });
                        } else if (sku == "dia500") {
                            var newCredit = userData.credit += 500;
                            ref.update({"credit": newCredit}, function(error) {
                                if (error) {
                                    res.end('{"status":"error"}');
                                } else {
                                    res.end('{"status":"ok"}');
                                }
                            });
                        } else if (sku == "dia1000") {
                            var newCredit = userData.credit += 50;
                            ref.update({"credit": newCredit}, function(error) {
                                if (error) {
                                    res.end('{"status":"error"}');
                                } else {
                                    res.end('{"status":"ok"}');
                                }
                            });
                        } else if (sku == "dia5000") {
                            var newCredit = userData.credit += 5000;
                            ref.update({"credit": newCredit}, function(error) {
                                if (error) {
                                    res.end('{"status":"error"}');
                                } else {
                                    res.end('{"status":"ok"}');
                                }
                            });
                        } else if (sku == "dia10000") {
                            var newCredit = userData.credit += 10000;
                            ref.update({"credit": newCredit}, function(error) {
                                if (error) {
                                    res.end('{"status":"error"}');
                                } else {
                                    res.end('{"status":"ok"}');
                                }
                            });
                        } else {
                            res.end('{"status":"error"}');
                        }
  
  
                    });
                      
                }).catch((error) => {
                    res.end('{"status":"auth_error"}');
                });
        } else {
            res.end('{"status":"mull_request"}');
        }
    }
    
});

app.get('/verify_reward', async (req, res, next) => {
    res.writeHead(200, {'Content-Type': 'application/json; charset=utf-8'});
    var q = url.parse(req.url, true);
    var pReq = q.query;

    if(pReq.user_id != null){
        var uid = pReq.user_id;
        var db = admin.database();
        var ref = db.ref("users").child(uid);

        admobSSV.verify(req.url, true).then(() => {
            ref.once("value", function(data) {
                var userData = data.val();
                var oldCredit = userData.credit;
                var newCredit = oldCredit += 1;
        
                ref.update({"credit": newCredit}, function(error) {
                    if (error) {
                        res.end('{"status":"error"}');
                    } else {
                        res.end('{"status":"ok"}');
                    }
                });
            });
        }).catch((e) => {
            res.end('{"status":"error"}');
        });
    }else{
        res.end('{"status":"null_request"}');
    }
});

app.get('/admin/systemTestFB/:token', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
     var token = req.params.token;
       
    if (token == serverToken) {
        var db = admin.database();
        var ref = db.ref("users").child("D0DM6rr811eePoZC6CRFNjyBBFh1");
        
        ref.once("value", function(data) {
            var userData = data.val();
             res.end('{"status":' + userData.credit + '}');
            
        });
       
    }else{
       res.end('{"status":"non_valid_token"}');
    }
});


app.listen(8080);